#include <Windows.h>
#include "../../client/EterFSLib/FileSystemIncl.hpp"


int32_t main(int32_t argc, char* argv[])
{
	if (argc != 3)
	{
		printf("Usage: %s <property_folder> <list_output_file>\n", argv[0]);
		return EXIT_FAILURE;
	}
	const auto* szPropertyFolder = argv[1];
	const auto* szListOutputFile = argv[2];

	auto* fs = new FileSystemManager();
	if (!fs || !fs->InitializeFSManager(
#ifdef ENABLE_LAYER2_FILE_ENCRYPTION
		FILE_FLAG_XTEA
#endif
	))
	{
		printf("File system initialization fail!\n");
		return EXIT_FAILURE;
	}
	Log(0, "Property generator started!");
	Sleep(2000);

	DeleteFileA(szListOutputFile);

	try
	{
		if (GeneratePropertyList(szPropertyFolder, szListOutputFile) == false)
		{
			printf("Property list can NOT created!\n");
			return EXIT_FAILURE;
		}
	}
	catch (const std::exception& e)
	{
		printf("Exception handled: %s\n", e.what());
		return EXIT_FAILURE;
	}
	catch (...)
	{
		printf("Unhandled exception\n");
		return EXIT_FAILURE;
	}

	printf("Property list successfully created!\n");

	fs->FinalizeFSManager();
	std::system("PAUSE");
	return EXIT_SUCCESS;
};
